#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/DrawERDlg.h"

Name::Name(QRectF& rect, const QString & text, QGraphicsItem * parent) : QGraphicsTextItem(text, parent)
{
	//this->setTextInteractionFlags(Qt::TextEditable);
	this->setPos(rect.x()+5, rect.y()+2);

	Canvas* canvas = DrawERDlg::getInstance()->GetCanvas();
	connect(this, SIGNAL(lostFocus1(Name *)), canvas, SLOT(editorLostFocus1(Name *)));
	//connect(this, SIGNAL(Delete()), (NameRect*)(this->parentItem()) , SLOT(DeleteName()));
}

Name::~Name()
{
}

void Name::Test()
{
	qDebug() << "NameTest";
}

void Name::keyPressEvent ( QKeyEvent * event )
{
	if( event->key() == Qt::Key_Enter || event->key() == Qt::Key_Return ){
		this->setSelected(false);
		this->clearFocus();		
	}

	else if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_Minus){
		//((NameRect*)(this->parentItem()))->DeleteName();
	}

	else{
		QGraphicsTextItem::keyPressEvent(event);
	}
}

void Name::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	this->scene()->clearSelection();
	setTextInteractionFlags(Qt::TextEditorInteraction);
    QGraphicsSceneMouseEvent *mouseEvent =
        new QGraphicsSceneMouseEvent(QEvent::GraphicsSceneMousePress);
    mouseEvent->setAccepted(true);
    mouseEvent->setPos(event->pos());
    mouseEvent->setScenePos(event->scenePos());
    mouseEvent->setScreenPos(event->screenPos());
    mouseEvent->setButtonDownPos(Qt::LeftButton,
        event->buttonDownPos(Qt::LeftButton));
    mouseEvent->setButtonDownScreenPos(Qt::LeftButton,
        event->buttonDownScreenPos(Qt::LeftButton));
    mouseEvent->setButtonDownScenePos(Qt::LeftButton,
        event->buttonDownScenePos(Qt::LeftButton));
    mouseEvent->setWidget(event->widget());
	
    QGraphicsTextItem::mousePressEvent(mouseEvent);
	
    delete mouseEvent;
}

void Name::focusOutEvent(QFocusEvent *event)
{
    this->setTextInteractionFlags(Qt::NoTextInteraction);
	
	Table* table = (Table*)(((NameRect*)(this->parentItem()))->parentItem());
	
	QRectF tableRect = table->boundingRect();
	QRectF textRect = this->boundingRect();
	
	if( tableRect.width() < this->boundingRect().width()+14 ){
		table->ReSize();
	}
	
	emit lostFocus1(this);
	
	QGraphicsTextItem::focusOutEvent(event);
}


